package fp;

/**
 * A set of H objects that can map an IMapAlgo lambda 
 * over the set.
 */
public interface IMapHost<H> {
  
  /**
   * Maps the given IMapAlgo lambda across the set of H objects.
   * @param algo  The lambda to map across the set.
   * @param inp A vararg list of arbitrary input parameters of type P.
   */
  public abstract <P> void map(IMapAlgo<H,P> algo, P... inp);
}
